/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.rendering.DebugRenderer;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.RenderingOptions;
import technology.rocketjump.undermount.rendering.WorldRenderer;
import technology.rocketjump.undermount.rendering.lighting.CombinedLightingResultRenderer;
import technology.rocketjump.undermount.rendering.lighting.LightProcessor;
import technology.rocketjump.undermount.rendering.lighting.PointLight;
import technology.rocketjump.undermount.rendering.lighting.WorldLightingRenderer;
import technology.rocketjump.undermount.sprites.TerrainSpriteCache;
import technology.rocketjump.undermount.ui.InWorldUIRenderer;

public class GameRenderer
implements Disposable {
    private final List<PointLight> allLights;
    private PointLight testLight;
    private boolean testLightEnabled = true;
    private final LightProcessor lightProcessor;
    private final SpriteBatch basicSpriteBatch = new SpriteBatch();
    private FrameBuffer diffuseFrameBuffer;
    private TextureRegion diffuseTextureRegion;
    private FrameBuffer bumpMapFrameBuffer;
    private TextureRegion bumpMapTextureRegion;
    private FrameBuffer lightingFrameBuffer;
    private TextureRegion lightingTextureRegion;
    private FrameBuffer combinedFrameBuffer;
    private TextureRegion combinedTextureRegion;
    private final OrthographicCamera viewportCamera;
    private final RenderingOptions renderingOptions;
    private final WorldRenderer worldRenderer;
    private final WorldLightingRenderer worldLightingRenderer;
    private final CombinedLightingResultRenderer combinedRenderer;
    private final DebugRenderer debugRenderer;
    private final InWorldUIRenderer inWorldUIRenderer;
    private final TerrainSpriteCache diffuseSpriteCache;
    private final TerrainSpriteCache normalSpriteCache;
    private final DebugWindow debugWindow;

    @Inject
    public GameRenderer(LightProcessor lightProcessor, RenderingOptions renderingOptions, WorldRenderer worldRenderer, WorldLightingRenderer worldLightingRenderer, CombinedLightingResultRenderer combinedRenderer, DebugRenderer debugRenderer, InWorldUIRenderer inWorldUIRenderer, @Named(value="diffuse") TerrainSpriteCache diffuseSpriteCache, @Named(value="normal") TerrainSpriteCache normalSpriteCache, DebugWindow debugWindow) {
        this.lightProcessor = lightProcessor;
        this.renderingOptions = renderingOptions;
        this.worldRenderer = worldRenderer;
        this.worldLightingRenderer = worldLightingRenderer;
        this.combinedRenderer = combinedRenderer;
        this.debugRenderer = debugRenderer;
        this.inWorldUIRenderer = inWorldUIRenderer;
        this.diffuseSpriteCache = diffuseSpriteCache;
        this.normalSpriteCache = normalSpriteCache;
        this.debugWindow = debugWindow;
        this.initFrameBuffers(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.viewportCamera = new OrthographicCamera();
        this.viewportCamera.setToOrtho(false);
        this.testLight = new PointLight();
        this.testLight.setColor(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        this.allLights = new LinkedList<PointLight>();
        this.allLights.add(this.testLight);
    }

    @Override
    public void dispose() {
        this.disposeFrameBuffers();
    }

    public void renderGame(TiledMap worldMap, OrthographicCamera camera) {
        int tileY;
        int screenX = Gdx.input.getX();
        int screenY = Gdx.input.getY();
        if (this.renderingOptions.debug().showIndividualLightingBuffers()) {
            screenX = this.renderingOptions.debug().adjustScreenXForSplitView(screenX);
            screenY = this.renderingOptions.debug().adjustScreenYForSplitView(screenY);
        }
        Vector3 unprojected = camera.unproject(new Vector3(screenX, screenY, 0.0f));
        int tileX = (int)Math.floor(unprojected.x);
        MapTile tileAtCursor = worldMap.getTile(tileX, tileY = (int)Math.floor(unprojected.y));
        if (tileAtCursor != null) {
            // empty if block
        }
        Vector2 testLightPosition = new Vector2(unprojected.x, unprojected.y);
        this.testLight.setWorldPosition(testLightPosition);
        this.allLights.clear();
        MapTile testLightTile = worldMap.getTile(testLightPosition);
        boolean bl = this.testLightEnabled = testLightTile != null && !testLightTile.hasWall();
        if (this.testLightEnabled) {
            this.lightProcessor.updateLightGeometry(this.testLight, worldMap);
            this.allLights.add(this.testLight);
        }
        this.diffuseFrameBuffer.begin();
        this.worldRenderer.renderWorld(worldMap, camera, this.diffuseSpriteCache, RenderMode.DIFFUSE, this.allLights);
        this.diffuseFrameBuffer.end();
        this.bumpMapFrameBuffer.begin();
        this.worldRenderer.renderWorld(worldMap, camera, this.normalSpriteCache, RenderMode.NORMALS, null);
        this.bumpMapFrameBuffer.end();
        this.lightingFrameBuffer.begin();
        this.worldLightingRenderer.renderWorldLighting(worldMap, this.allLights, camera, this.bumpMapTextureRegion);
        this.lightingFrameBuffer.end();
        if (this.renderingOptions.debug().showIndividualLightingBuffers()) {
            this.combinedFrameBuffer.begin();
            this.combinedRenderer.renderFinal(this.diffuseTextureRegion, this.lightingTextureRegion);
            this.combinedFrameBuffer.end();
            this.basicSpriteBatch.begin();
            this.basicSpriteBatch.disableBlending();
            this.basicSpriteBatch.setProjectionMatrix(this.viewportCamera.projection);
            this.basicSpriteBatch.draw(this.diffuseTextureRegion, (float)(-Gdx.graphics.getWidth()) / 2.0f, 0.0f, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
            this.basicSpriteBatch.draw(this.bumpMapTextureRegion, 0.0f, 0.0f, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
            this.basicSpriteBatch.draw(this.lightingTextureRegion, (float)(-Gdx.graphics.getWidth()) / 2.0f, (float)(-Gdx.graphics.getHeight()) / 2.0f, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
            this.basicSpriteBatch.draw(this.combinedTextureRegion, 0.0f, (float)(-Gdx.graphics.getHeight()) / 2.0f, (float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f);
            this.basicSpriteBatch.end();
        } else {
            this.combinedRenderer.renderFinal(this.diffuseTextureRegion, this.lightingTextureRegion);
            this.inWorldUIRenderer.render(worldMap, camera, this.diffuseSpriteCache);
        }
        this.debugRenderer.render(worldMap, camera);
    }

    public void onResize(int width, int height) {
        this.viewportCamera.setToOrtho(false, width, height);
        this.disposeFrameBuffers();
        this.initFrameBuffers(width, height);
    }

    private void initFrameBuffers(int width, int height) {
        this.diffuseFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false, false);
        this.diffuseTextureRegion = new TextureRegion((Texture)this.diffuseFrameBuffer.getColorBufferTexture(), width, height);
        this.diffuseTextureRegion.flip(false, true);
        this.bumpMapFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false, false);
        this.bumpMapTextureRegion = new TextureRegion((Texture)this.bumpMapFrameBuffer.getColorBufferTexture(), width, height);
        this.bumpMapTextureRegion.flip(false, true);
        this.lightingFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false, false);
        this.lightingTextureRegion = new TextureRegion((Texture)this.lightingFrameBuffer.getColorBufferTexture(), width, height);
        this.lightingTextureRegion.flip(false, true);
        this.combinedFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, false, false);
        this.combinedTextureRegion = new TextureRegion((Texture)this.combinedFrameBuffer.getColorBufferTexture(), width, height);
        this.combinedTextureRegion.flip(false, true);
    }

    private void disposeFrameBuffers() {
        this.diffuseFrameBuffer.dispose();
        this.bumpMapFrameBuffer.dispose();
        this.lightingFrameBuffer.dispose();
        this.combinedFrameBuffer.dispose();
    }
}

